/*{
	"GUID":"647304F8-B2DC-4200-B8B2-E8FF95020A44"
}*/

#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define _max(a,b) (a)>(b)?(a):(b)
#define _min(a,b) (a)<(b)?(a):(b)
#define _abs(a)	(float4)( (a).x>0.0f?(a).x:-(a).x, (a).y>0.0f?(a).y:-(a).y, (a).z>0.0f?(a).z:-(a).z, (a).w>0.0f?(a).w:-(a).w)
#define SRC src_data
#define OVERLAY1 ovelay1

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE| CLK_FILTER_LINEAR;
vec4 INPUT(image2d_t src_data,  __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

//uniform vec2 PREFIX(offset)[9];

//This sketch algorithm is our own inverted method of sketch
//Sketch

__kernel void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,        //Data in global memory
      __global FilterParam* param,
	  int alpha) //range[0 - 100] // the gpu items/threads should be newW*newH
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	float2 iResolution = (float2)(W,H);
	vec2 tc = (fragCoord + (vec2)(0.5f)) / (float2)(W,H);
	
	vec4 tempColor = INPUT(src_data, param,	tc);
    vec4 sample[9];
	vec2 offset[9] = 
                { 
                        (vec2)(-1.0f/W, -1.0f/H), 
                        (vec2)(0.0f, -1.0f/H), 
                        (vec2)(1.0f/W, -1.0f/H), 
                        (vec2)(-1.0f/W,    0.0f), 
                        (vec2)(0.0f,    0.0f), 
                        (vec2)(1.0f/W,    0.0f), 
                        (vec2)(-1.0f/W,  1.0f/H), 
                        (vec2)(0.0f,  1.0f/H), 
                        (vec2)(1.0f/W,  1.0f/H)
                };
	
    for(int i=0; i < 9; i++)
    {
        sample[i] = INPUT(src_data, param, tc + offset[i]);
    }    
    vec4 result = sqrt(    (-sample[0] - sample[1] * 2.0f - sample[2] + sample[6] + sample[7] * 2.0f + sample[8])
                         * (-sample[0] - sample[1] * 2.0f - sample[2] + sample[6] + sample[7] * 2.0f + sample[8]) 
                         + (-sample[0] - sample[3] * 2.0f - sample[6] + sample[2] + sample[5] * 2.0f + sample[8])
                         * (-sample[0] - sample[3] * 2.0f - sample[6] + sample[2] + sample[5] * 2.0f + sample[8]));
    float gray = 1.0f - dot(result.rgb, (vec3)(0.114f, 0.587f, 0.299f));
	float4 color = gray * 2.0f * tempColor;
	
	float4 output = tempColor*(1.0f - alpha/100.0f) + color*alpha/100.0f;
	 
	write_imagef(dest_data, coordinate, (vec4)(output.xyz, tempColor.w));

}
